package gov.cms.grouper.snf.app;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;


/**
 * if there is issue running this.. please run maven build before running it
 * 
 *
 */
@State(Scope.Benchmark)
public class PdpmPerformanceTest {

  public static final int fork = 1;
  public static final int iterations = 1;

  public static final long performanceBoundForLocal = 1600000; // 1600000 MicroSecond = 1600
                                                               // milliSecond =
  // 1.6 seconds

  public volatile Pdpm pdpm;
  private volatile List<String> lines;

  // Because Jenkins does not allow us to use that much cpu cycle so the process slows down
  private String boundForJenkinsString = null;


  @Test
  public void launchBenchmark() throws Exception {
    long bound = performanceBoundForLocal;
    if (boundForJenkinsString != null) {
      System.out.println("Using Jenkin Performance Bond input: " + this.boundForJenkinsString);
      bound = Integer.parseInt(boundForJenkinsString);
    } else {
      System.out
          .println("Using Local Performance Bound: " + PdpmPerformanceTest.performanceBoundForLocal);
    }


    Options opt = new OptionsBuilder()
        // Specify which benchmarks to run.
        // You can be more specific if you'd like to run only one benchmark per test.
        .include(this.getClass().getSimpleName())
        // Set the following options as needed
        .mode(Mode.AverageTime).timeUnit(TimeUnit.MICROSECONDS).warmupIterations(iterations)
        .measurementIterations(iterations).threads(2).forks(fork).shouldFailOnError(true)
        .shouldDoGC(true)
        // .jvmArgs("-XX:+UnlockDiagnosticVMOptions", "-XX:+PrintInlining")
        // .addProfiler(WinPerfAsmProfiler.class)
        .build();

    Collection<RunResult> results = new Runner(opt).run();
    final String fmt = "%s time: %d %s";

    for (RunResult r : results) {
      Double d = r.getPrimaryResult().getScore();
      long time = d.longValue();
      String unit = r.getPrimaryResult().getScoreUnit();
      String methodName = r.getPrimaryResult().getLabel();
      System.out.println(String.format(fmt, methodName, time, unit));
      if (methodName.contains("10K")) {
        System.out.println("testing performance result: " + time + " < " + bound);
        Assertions.assertTrue(time < bound);
      }
    }
  }

  public static void main(String[] args) throws Exception {

    PdpmPerformanceTest test = new PdpmPerformanceTest();
    if (args != null && args.length > 0) {
      test.boundForJenkinsString = args[0];
    }
    test.setup();
    test.launchBenchmark();
  }

  @Setup
  public void setup() throws Exception {
    Path path = Paths.get(ClassLoader.getSystemResource("10KRecordTest.txt").toURI());
    pdpm = new Pdpm();
    lines = pdpm.processFile(null, path, (line) -> line);
  }

  @Benchmark
  public Pdpm testMds10KRecordTest() throws Exception {
    System.setProperty("dryRun", "true");
    Logger log = SnfUtils.cast(LogManager.getRootLogger());
    Level old = log.getLevel();
    log.setLevel(Level.OFF);

    pdpm.exec(null, lines);

    log.setLevel(old);
    return pdpm;
  }



}
